	function A = lp_get_spec2(zstep,amin,z)
	% 
	% Returns the specification in the stopband for a given frequency z,
	% given the stepfrequencies and the piecewise constant stopband requirements.
	% Use for lowpass filters.
	% A = lp_get_spec(zstep,amin,z)
	
	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	low_index = max(find(zstep <= z));
	high_index = min(find(zstep >= z));
	if isempty(high_index)
		disp('Error-frequency out of range');
		A = 0;
	else
		if isempty(low_index)
			A = amin(high_index);
		elseif low_index == high_index
			if high_index == length(zstep)
				A = amin(length(zstep));
			else
				A = max(amin(low_index),amin(low_index+1));
			end
		else
			A = amin(high_index);    
		end
	end
